/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.registry.chunk.write;

import dev.quantumfusion.dashloader.DashObjectClass;
import dev.quantumfusion.dashloader.Dashable;
import dev.quantumfusion.dashloader.registry.RegistryWriter;
import dev.quantumfusion.dashloader.registry.chunk.data.AbstractDataChunk;
import dev.quantumfusion.dashloader.registry.chunk.data.StagedDataChunk;
import dev.quantumfusion.dashloader.registry.chunk.write.AbstractWriteChunk;
import dev.quantumfusion.dashloader.registry.factory.DashFactory;
import dev.quantumfusion.dashloader.thread.IndexedArrayMapTask;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.List;

public class StagedWriteChunk<R, D extends Dashable<R>>
extends AbstractWriteChunk<R, D> {
    private final Object2ObjectLinkedOpenHashMap<Class<?>, List<IndexedArrayMapTask.IndexedArrayEntry<D>>> dashList = new Object2ObjectLinkedOpenHashMap();
    private int currentPos = 0;

    public StagedWriteChunk(byte pos, String name, RegistryWriter writer, List<DashObjectClass<R, D>> dashObjects, DashFactory<R, D> factory) {
        super(pos, name, writer, factory, dashObjects);
        dashObjects.forEach(dashObject -> this.dashList.put(dashObject.getDashClass(), new ArrayList()));
    }

    @Override
    public int add(R raw) {
        Object created = this.factory.create(raw, this.writer);
        ((List)this.dashList.computeIfAbsent(created.getClass(), c -> new ArrayList())).add(new IndexedArrayMapTask.IndexedArrayEntry(created, this.currentPos));
        return this.currentPos++;
    }

    @Override
    public AbstractDataChunk<R, D> exportData() {
        IndexedArrayMapTask.IndexedArrayEntry[][] out = new IndexedArrayMapTask.IndexedArrayEntry[this.dashList.size()][];
        int i = 0;
        int size = 0;
        for (List value : this.dashList.values()) {
            out[i++] = (IndexedArrayMapTask.IndexedArrayEntry[])value.toArray(IndexedArrayMapTask.IndexedArrayEntry[]::new);
            size += value.size();
        }
        return new StagedDataChunk(this.pos, this.name, out, size);
    }
}

